const int geigerPin = 3; // Digital pin connected to Geiger counter
volatile int eventCount = 0; // Stores detected events (short-term)
volatile int cpmCount = 0;   // Stores counts per minute (long-term)

unsigned long lastLongUpdate = 0;

void countEvent() {
    eventCount++; // Increment short-term count
    cpmCount++;   // Increment long-term count
}

void setup() {
    Serial.begin(115200); // Initialize Serial communication
    pinMode(geigerPin, INPUT);
    attachInterrupt(digitalPinToInterrupt(geigerPin), countEvent, RISING);
}

void loop() {
    static unsigned long timeMillis = 0;
    static int cpm = 0;
    static float cps = 0;

    // Every 60 seconds → Track counts per minute (CPM)
    if (millis() - lastLongUpdate >= 60000) {
        lastLongUpdate = millis();

        noInterrupts();
        cpm = cpmCount;
        cpmCount = 0; // Reset long-term count
        interrupts();

        cps = cpm / 60.0; // Convert to counts per second

        Serial.print(" CPS: ");
        Serial.println(cps, 2); // Print CPS with 2 decimal points
    }
}
